<?php
/*
* Plugin Name: Constant Contact LeadGen & CRM WP Form Connection
* Description: Connect WP Forms to LeadGen & CRM from Constant Contact
* Version: 1.0
* Author: Constant Contact Lead Gen and CRM Support
*/

function wpf_dev_process_complete( $fields, $entry, $form_data, $entry_id ) {

    $body = [];
    $submitToSharpSpring = false;

// Store the data from the submission in variables.
    $entry = wpforms()->entry->get( $entry_id );
    $new_json = str_replace("\\n", "\\" . "\\n", "$entry->fields");
    $entry_fields = json_decode( $new_json, true );

// Sanitize all field labels to alphanumeric. Add a digit, 0-20, to the end of any field with a duplicate name
    function dupeCheck($fieldName, $bodyData) {
        $cleanLabel = substr(preg_replace("/[^a-zA-Z0-9]+/", "", $fieldName), 0, 24);
        for ($x = 0; $x <= 20; $x++) {
        if(array_key_exists($cleanLabel, $bodyData)) {
            $cleanLabel = $cleanLabel . $x;
        } else { break; }
        } 
        return $cleanLabel;
 }

// Step through each field
    foreach($entry_fields as $formField):

        $fieldName = $formField["name"];

        // handle checkboxes by making a comma separated list of the values
        if ($formField["type"] == "checkbox") {
           $body[dupeCheck($fieldName, $body)] = str_replace("\\n", ",", $formField["value"]);

        // Handle WP Forms Fancy name field
        } elseif ($formField["type"] == "name") {
           $body[dupeCheck(($fieldName . "FieldFirstName"), $body)] = $formField["first"];
           $body[dupeCheck(($fieldName . "FieldMiddleName"), $body)] = $formField["middle"];
           $body[dupeCheck(($fieldName . "FieldLastName"), $body)] = $formField["last"];

        // Handle WP Forms Fancy address field
        } elseif ($formField["type"] == "address") {
           $body[dupeCheck(($fieldName . "FieldAddress1"), $body)] = $formField["address1"];
           $body[dupeCheck(($fieldName . "FieldAddress2"), $body)] = $formField["address2"];
           $body[dupeCheck(($fieldName . "FieldCity"), $body)] = $formField["city"];
           $body[dupeCheck(($fieldName . "FieldState"), $body)] = $formField["state"];
           $body[dupeCheck(($fieldName . "FieldPostalCode"), $body)] = $formField["postal"];
           $body[dupeCheck(($fieldName . "FieldCountry"), $body)] = $formField["country"];

        // Convert Date/Time data to SharpSpring format
        } elseif ($formField["type"] == "date-time") {
            if ($formField["time"] != "") {
                $body[dupeCheck($fieldName, $body)] = str_replace(array("T", "Z"), array(" ", ""), gmdate("Y-m-d\TH:i:s\Z", $formField["unix"]));
            } else {
                $body[dupeCheck($fieldName, $body)] = str_replace(array("T", "Z"), array(" ", ""), gmdate("Y-m-d", $formField["unix"]));
            }    

        // Capture endpoint data and handle other hidden fields
        } elseif ($formField["type"] == "hidden") {
            if ( $fieldName == "base uri" ) {
                $base_uri = $formField["value"];
            } else if ( $fieldName == "endpoint") {
                $endpoint = $formField["value"];
                $submitToSharpSpring = true;
            } else {
                $body[dupeCheck($fieldName, $body)] = $formField["value"];

            } 

        } else {
            $body[dupeCheck($fieldName, $body)] = $formField["value"];
        }        

    endforeach;

    // Add the tracking cookie to the values and make the network request.
    $body["trackingid__sb"] = $_COOKIE["__ss_tk"]; //DO NOT CHANGE THIS LINE... it collects the tracking cookie to establish tracking
    if ($submitToSharpSpring) {
        $post_url = $base_uri . $endpoint;

        $request = new WP_Http();
        $response = $request->post( $post_url, array( "body" => $body ) );
    }
}

// Listener provided by WPforms. On receiving a submission, calls the function in the second parameter.
add_action( 'wpforms_process_complete', 'wpf_dev_process_complete', 10, 4 );

?>