<?php
/*
* Plugin Name: Constant Contact LeadGen & CRM Ninja Forms 3 Connection
* Description: Connect Ninja Forms 3 to LeadGen & CRM from Constant Contact
* Version: 1.0
* Author: Constant Contact Lead Gen and CRM Support
*/

// Listener provied by Ninja Forms. On receiving a submission, runs the defined function.
add_action( 'ninja_forms_after_submission', 'send_ninja_form_to_sharpspring' );

// Functiont that will gather and send form data.
function send_ninja_form_to_sharpspring($formData){
	
	// Store the Form Fields object in its own variable
	$formFields = $formData['fields_by_key'];
	
	// Step through all the fields
	foreach($formFields as $formField):
		// Gather the hidden url field.
		if($formField['key']=='sharpspring_post_url')://if this field is the sharpspring post url
			$post_url = $formField['value'];
		
		else: //it's a form field, so let's add it to the body
			
			//if they specified an admin label to make it easier to map fields in sharpspring, use it instead
			$trimmedName = trim($formField['admin_label']);
                        if(!empty($trimmedName)):
				$fieldNiceName = $formField['admin_label'];
			else://use the field key
				$fieldNiceName = $formField['key'];
			endif;
			
			//add this field to the body
			if($formField['type'] != 'listcheckbox' && $formField['type'] != 'listmultiselect'):
				$body[$fieldNiceName] = $formField['value'];
			else://implode values if it is a checkbox or multi-select to convert to a comma-separated list
				$body[$fieldNiceName] = implode(',',$formField['value']);
			endif;

		endif;
		
	endforeach;
	
	$body['trackingid__sb'] = $_COOKIE['__ss_tk']; //DO NOT CHANGE THIS LINE... it collects the tracking cookie to establish tracking

    // Make the network request
	$request = new WP_Http();
	$response = $request->post( $post_url, array( 'body' => $body ) );

}

?>